/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vectorwing.farmersdelight.blocks.StoveBlock;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.utils.MathUtils;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class StoveTileEntity
extends TileEntity
implements IClearable,
ITickableTileEntity {
    private static final VoxelShape GRILLING_AREA = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private final int MAX_STACK_SIZE = 6;
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTotalTimes = new int[6];
    protected final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);

    public StoveTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public StoveTileEntity() {
        this((TileEntityType)ModTileEntityTypes.STOVE_TILE.get());
    }

    public void func_73660_a() {
        boolean isStoveLit = (Boolean)this.func_195044_w().func_177229_b((Property)StoveBlock.LIT);
        boolean isStoveBlocked = this.isStoveBlockedAbove();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            if (isStoveLit) {
                this.addParticles();
            }
        } else {
            if (this.field_145850_b != null && isStoveBlocked && !this.inventory.isEmpty()) {
                InventoryHelper.func_219961_a((World)this.field_145850_b, (BlockPos)this.field_174879_c, this.getInventory());
                this.inventoryChanged();
            }
            if (isStoveLit && !isStoveBlocked) {
                this.cookAndDrop();
            } else {
                for (int i = 0; i < this.inventory.size(); ++i) {
                    if (this.cookingTimes[i] <= 0) continue;
                    this.cookingTimes[i] = MathHelper.func_76125_a((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTotalTimes[i]);
                }
            }
        }
    }

    private void cookAndDrop() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventory.get(i);
            if (itemstack.func_190926_b()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTotalTimes[i]) continue;
            if (this.field_145850_b != null) {
                Inventory inventory = new Inventory(new ItemStack[]{itemstack});
                ItemStack result = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)inventory, this.field_145850_b).map(arg_0 -> StoveTileEntity.lambda$cookAndDrop$0((IInventory)inventory, arg_0)).orElse(itemstack);
                if (!result.func_190926_b()) {
                    ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, result.func_77946_l());
                    entity.func_213293_j(MathUtils.RAND.nextGaussian() * (double)0.01f, (double)0.1f, MathUtils.RAND.nextGaussian() * (double)0.01f);
                    this.field_145850_b.func_217376_c((Entity)entity);
                }
            }
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            this.inventoryChanged();
        }
    }

    public boolean isStoveBlockedAbove() {
        if (this.field_145850_b != null) {
            BlockState above = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
            return VoxelShapes.func_197879_c((VoxelShape)GRILLING_AREA, (VoxelShape)above.func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a()), (IBooleanFunction)IBooleanFunction.field_223238_i_);
        }
        return false;
    }

    public Vector2f getStoveItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        Vector2f[] OFFSETS = new Vector2f[]{new Vector2f(0.3f, 0.2f), new Vector2f(0.0f, 0.2f), new Vector2f(-0.3f, 0.2f), new Vector2f(0.3f, -0.2f), new Vector2f(0.0f, -0.2f), new Vector2f(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    private void addParticles() {
        World world = this.func_145831_w();
        if (world != null) {
            BlockPos blockpos = this.func_174877_v();
            Random random = world.field_73012_v;
            for (int j = 0; j < this.inventory.size(); ++j) {
                if (((ItemStack)this.inventory.get(j)).func_190926_b() || !(random.nextFloat() < 0.2f)) continue;
                double d0 = (double)blockpos.func_177958_n() + 0.5;
                double d1 = (double)blockpos.func_177956_o() + 1.0;
                double d2 = (double)blockpos.func_177952_p() + 0.5;
                Vector2f v1 = this.getStoveItemOffset(j);
                Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)StoveBlock.field_185512_D);
                int directionIndex = direction.func_176736_b();
                Vector2f offset = directionIndex % 2 == 0 ? v1 : new Vector2f(v1.field_189983_j, v1.field_189982_i);
                double d5 = d0 - (double)((float)direction.func_82601_c() * offset.field_189982_i) + (double)((float)direction.func_176746_e().func_82601_c() * offset.field_189982_i);
                double d7 = d2 - (double)((float)direction.func_82599_e() * offset.field_189983_j) + (double)((float)direction.func_176746_e().func_82599_e() * offset.field_189983_j);
                for (int k = 0; k < 3; ++k) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d5, d1, d7, 0.0, 5.0E-4, 0.0);
                }
            }
        }
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        if (compound.func_150297_b("CookingTimes", 11)) {
            int[] aint = compound.func_74759_k("CookingTimes");
            System.arraycopy(aint, 0, this.cookingTimes, 0, Math.min(this.cookingTotalTimes.length, aint.length));
        }
        if (compound.func_150297_b("CookingTotalTimes", 11)) {
            int[] aint1 = compound.func_74759_k("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTotalTimes, 0, Math.min(this.cookingTotalTimes.length, aint1.length));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeItems(compound);
        compound.func_74783_a("CookingTimes", this.cookingTimes);
        compound.func_74783_a("CookingTotalTimes", this.cookingTotalTimes);
        return compound;
    }

    private CompoundNBT writeItems(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)true);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public Optional<CampfireCookingRecipe> findMatchingRecipe(ItemStack itemStackIn) {
        return this.field_145850_b == null || this.inventory.stream().noneMatch(ItemStack::func_190926_b) ? Optional.empty() : this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, (IInventory)new Inventory(new ItemStack[]{itemStackIn}), this.field_145850_b);
    }

    public boolean addItem(ItemStack itemStackIn, int cookTime) {
        for (int i = 0; i < this.inventory.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventory.get(i);
            if (!itemstack.func_190926_b()) continue;
            this.cookingTotalTimes[i] = cookTime;
            this.cookingTimes[i] = 0;
            this.inventory.set(i, (Object)itemStackIn.func_77979_a(1));
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    private void inventoryChanged() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    private static /* synthetic */ ItemStack lambda$cookAndDrop$0(IInventory inventory, CampfireCookingRecipe recipe) {
        return recipe.func_77572_b(inventory);
    }
}

